/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.ArrayList;
import java.util.Iterator;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.RPG;
import mikera.tyrant.Script;
import mikera.tyrant.Text;
import mikera.tyrant.Thing;

public class Quest {
    public static ArrayList getQuests() {
        ArrayList arrayList = (ArrayList)Game.hero().get("Quests");
        if (arrayList == null) {
            arrayList = new ArrayList();
            Game.hero().set("Quests", arrayList);
        }
        return arrayList;
    }

    public static String getQuestText(Thing thing) {
        StringBuffer stringBuffer = new StringBuffer();
        Quest.getQuestText(stringBuffer, "", thing);
        return stringBuffer.toString();
    }

    private static void getQuestText(StringBuffer stringBuffer, String string, Thing thing) {
        String string2 = thing.getString("Description");
        if (string2 != null) {
            stringBuffer.append(string);
            stringBuffer.append(Text.capitalise(string2));
            if (thing.getFlag("IsComplete")) {
                stringBuffer.append(" (complete)");
            }
            if (thing.getFlag("IsFailed")) {
                stringBuffer.append(" (failed)");
            }
            stringBuffer.append("\n");
            ArrayList arrayList = Quest.getSubQuests(thing);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Thing thing2 = (Thing)iterator.next();
                Quest.getQuestText(stringBuffer, string + " - ", thing2);
            }
        }
    }

    public static void addQuest(Thing thing, Thing thing2) {
        ArrayList<Thing> arrayList = (ArrayList<Thing>)thing.get("Quests");
        if (arrayList == null) {
            arrayList = new ArrayList<Thing>();
            thing.set("Quests", arrayList);
        }
        thing2.set("Hero", thing);
        arrayList.add(thing2);
    }

    public static boolean notifyAction(Event event) {
        return Quest.notify(event);
    }

    public static boolean notifyKill(Event event) {
        return Quest.notify(event);
    }

    private static boolean notify(Event event) {
        ArrayList arrayList = Quest.getQuests();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Thing thing = (Thing)iterator.next();
            if (!thing.getFlag("IsActive")) continue;
            thing.handle(event);
        }
        return false;
    }

    private static ArrayList getSubQuests(Thing thing) {
        ArrayList arrayList = (ArrayList)thing.get("Quests");
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    public static void addSubQuest(Thing thing, Thing thing2) {
        ArrayList<Thing> arrayList = (ArrayList<Thing>)thing.get("Quests");
        if (arrayList == null) {
            arrayList = new ArrayList<Thing>();
            thing.set("Quests", arrayList);
        }
        thing2.set("Parent", thing);
        arrayList.add(thing2);
    }

    public static void setComplete(Thing thing) {
        BaseObject baseObject;
        if (!thing.getFlag("IsActive")) {
            throw new Error("Trying to complete a non-active quest");
        }
        thing.set("IsComplete", 1);
        thing.set("IsActive", 0);
        if (thing.handles("OnQuestComplete")) {
            baseObject = new Event("QuestComplete");
            baseObject.set("Quest", thing);
            thing.handle((Event)baseObject);
        }
        if ((baseObject = thing.getThing("Parent")) != null) {
            Event event = new Event("SubQuestComplete");
            event.set("Quest", thing);
            thing.handle(event);
        }
    }

    public static void setFailed(Thing thing) {
        BaseObject baseObject;
        if (!thing.getFlag("IsActive")) {
            throw new Error("Trying to fail a non-active quest");
        }
        thing.set("IsFailed", 1);
        thing.set("IsActive", 0);
        if (thing.handles("OnQuestFailed")) {
            baseObject = new Event("QuestFailed");
            baseObject.set("Quest", thing);
            thing.handle((Event)baseObject);
        }
        if ((baseObject = thing.getThing("Parent")) != null) {
            Event event = new Event("SubQuestFailed");
            event.set("Quest", thing);
            thing.handle(event);
        }
    }

    public static Thing createKillQuest(String string, Thing thing) {
        Thing thing2 = Lib.create("kill quest");
        thing2.set("Target", thing);
        thing2.set("Description", string);
        return thing2;
    }

    public static Thing createKillNumberQuest(String string, String string2, int n) {
        Thing thing = Lib.create("kill number quest");
        if (string2.startsWith("[")) {
            thing.set("TargetType", string2.substring(1, string2.length() - 1));
        } else {
            thing.set("TargetName", string2);
        }
        thing.set("TargetCount", n);
        thing.set("Description", string);
        return thing;
    }

    public static Thing createMeetQuest(String string, Thing thing) {
        Thing thing2 = Lib.create("meet quest");
        thing2.set("Target", thing);
        thing2.set("Description", string);
        return thing2;
    }

    public static Thing createVisitMapQuest(String string, Map map) {
        Thing thing = Lib.create("visit map quest");
        thing.set("TargetMap", map);
        thing.set("Description", string);
        return thing;
    }

    public static Thing createVisitMapQuest(String string, String string2) {
        Thing thing = Lib.create("visit map quest");
        thing.set("TargetMapName", string2);
        thing.set("Description", string);
        return thing;
    }

    public static void init() {
        Thing thing = Lib.extend("base quest", "base thing");
        thing.set("LevelMin", 1);
        thing.set("IsQuest", 1);
        thing.set("IsActive", 1);
        thing.set("IsPhysical", 0);
        thing.set("Frequency", 50);
        thing.set("OnQuestComplete", new Script(){

            public boolean handle(Thing thing, Event event) {
                String string = thing.getString("Description");
                if (string != null) {
                    Game.message("Quest objective complete: " + string);
                }
                return false;
            }
        });
        Lib.add(thing);
        thing = Lib.extend("kill quest", "base quest");
        thing.addHandler("OnKill", new Script(){

            public boolean handle(Thing thing, Event event) {
                Thing thing2 = thing.getThing("Target");
                if (thing2 != null && thing2.isDead()) {
                    Quest.setComplete(thing);
                }
                return false;
            }
        });
        Lib.add(thing);
        thing = Lib.extend("kill number quest", "base quest");
        thing.addHandler("OnKill", new Script(){

            public boolean handle(Thing thing, Event event) {
                int n = thing.getStat("TargetCount");
                int n2 = thing.getStat("CurrentCount");
                Thing thing2 = event.getThing("Target");
                String string = thing.getString("TargetName");
                boolean bl = false;
                if (string != null) {
                    if (string.equals(thing2.name())) {
                        bl = true;
                    }
                } else {
                    String string2 = thing.getString("TargetType");
                    if (string2 != null && thing2.getFlag(string2)) {
                        bl = true;
                    }
                }
                if (bl) {
                    thing.set("CurrentCount", ++n2);
                    if (n2 >= n) {
                        Quest.setComplete(thing);
                    }
                }
                return false;
            }
        });
        Lib.add(thing);
        thing = Lib.extend("visit map quest", "base quest");
        thing.addHandler("OnAction", new Script(){

            public boolean handle(Thing thing, Event event) {
                Map map = (Map)thing.get("TargetMap");
                Map map2 = Game.hero().getMap();
                if (map == null) {
                    String string = thing.getString("TargetMapName");
                    if (map2.name().startsWith(string)) {
                        Quest.setComplete(thing);
                    }
                } else if (map2 == map) {
                    Quest.setComplete(thing);
                }
                return false;
            }
        });
        Lib.add(thing);
        thing = Lib.extend("meet quest", "base quest");
        thing.addHandler("OnAction", new Script(){

            public boolean handle(Thing thing, Event event) {
                Thing thing2 = thing.getThing("Target");
                Thing thing3 = Game.hero();
                if (thing2.isDead()) {
                    Quest.setFailed(thing);
                    return false;
                }
                if (thing3.place != thing2.place) {
                    return false;
                }
                if (RPG.abs(thing3.x - thing2.x) <= 1 && RPG.abs(thing3.y - thing2.y) <= 1) {
                    Quest.setComplete(thing);
                }
                return false;
            }
        });
        Lib.add(thing);
        thing = Lib.extend("sequence quest", "base quest");
        Script script = new Script(){

            public boolean handle(Thing thing, Event event) {
                ArrayList arrayList = Quest.getSubQuests(thing);
                boolean bl = true;
                boolean bl2 = true;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Thing thing2 = (Thing)iterator.next();
                    if (thing2.getFlag("IsFailed")) {
                        bl2 = true;
                    }
                    if (thing2.getFlag("IsComplete")) continue;
                    bl = false;
                }
                if (bl2) {
                    Quest.setFailed(thing);
                } else if (bl) {
                    Quest.setComplete(thing);
                }
                return false;
            }
        };
        thing.addHandler("OnSubQuestComplete", script);
        thing.addHandler("OnSubQuestFailed", script);
        Lib.add(thing);
    }
}

