/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.util.ArrayList;
import java.util.Iterator;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Being;
import mikera.tyrant.Effect;
import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.Modifier;
import mikera.tyrant.Poison;
import mikera.tyrant.RPG;
import mikera.tyrant.Recipe;
import mikera.tyrant.Script;
import mikera.tyrant.Scripts;
import mikera.tyrant.Skill;
import mikera.tyrant.Spell;
import mikera.tyrant.Thing;

public class Potion {
    private static String[] potionstyles = new String[]{"frothy", "bubbling", "oily", "small", "tiny", "smelly", "fragrant", "boiling", "glowing", "milky", "murky", "cloudy", "sizzling", "flaming", "fuming", "shimmering"};
    private static String[] potioncolours = new String[]{"red", "burgundy", "orange", "yellow", "green", "blue", "aquamarine", "cyan", "sky blue", "brown", "indigo", "violet", "purple", "pink", "grey", "white", "black", "rainbow"};
    private static int[] images = new int[]{245, 245, 240, 240, 247, 246, 248, 248, 248, 243, 244, 244, 244, 250, 243, 242, 241, 251};

    public static void addPotion(Thing thing) {
        int n = RPG.r(potionstyles.length);
        int n2 = RPG.r(potioncolours.length);
        thing.set("ImageSource", "Items");
        thing.set("Image", images[n2]);
        thing.set("UName", potionstyles[n] + " " + potioncolours[n2] + " potion");
        String string = thing.getString("Name");
        if (string.indexOf("potion") == 0) {
            String string2 = "potions" + string.substring(6);
            thing.set("NamePlural", string2);
        }
        Lib.add(thing);
        Recipe.register("Alchemy", thing, 2);
    }

    public static Thing createPotion() {
        return Potion.createPotion(Game.level());
    }

    public static Thing createPotion(int n) {
        return Lib.createType("IsPotion", n);
    }

    public static void dip(Thing thing, Thing thing2, Thing thing3) {
        if (thing3.handles("OnDip")) {
            Event event = new Event("Dip");
            event.set("Target", thing2);
            event.set("User", thing);
            thing3.handle(event);
        }
    }

    public static void drink(Thing thing, Thing thing2) {
        thing.incStat("APS", -Being.actionCost(thing));
        if (thing2.getFlag("IsDrinkable")) {
            Item.identify(thing2);
            Thing thing3 = thing2.remove(1);
            thing.message("You drink " + thing3.getTheName());
            if (thing2.handles("OnDrunk")) {
                Event event = new Event("Drunk");
                event.set("Target", thing);
                if (thing2.handle(event)) {
                    return;
                }
            }
        } else {
            Game.warn("Potion.drink: drinking problem");
        }
    }

    public static void init() {
        Thing thing = Lib.extend("base potion", "base item");
        thing.set("IsPotion", 1);
        thing.set("IsDrinkable", 1);
        thing.set("IsMagicItem", 1);
        thing.set("IsFragile", 1);
        thing.set("RES:impact", -5);
        thing.set("Image", 240);
        thing.set("HPS", 2);
        thing.set("LevelMin", 1);
        thing.set("ValueBase", 200);
        thing.set("ItemWeight", 500);
        thing.set("OnUse", new DipScript());
        thing.set("Frequency", 60);
        thing.set("ASCII", "!");
        thing.set("IsAlchemyIngredient", 1);
        Lib.add(thing);
        Potion.initSpecialPotions();
        Potion.initRandomPotions();
        Potion.initSpellPotions();
    }

    private static void initSpellPotions() {
        ArrayList arrayList = Spell.getSpellNames();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Thing thing = Spell.create(string);
            if (thing.getStat("SpellTarget") != 1) continue;
            int n = thing.getLevel();
            Thing thing2 = Lib.extend("potion of " + string, "base potion");
            thing2.set("NamePlural", "potions of " + string);
            thing2.set("LevelMin", n);
            thing2.set("OnDrunk", Scripts.spellEffect("Target", string, 100));
            Potion.addPotion(thing2);
        }
    }

    public static void initSpecialPotions() {
        Thing thing = Lib.extend("potion of water", "base potion");
        thing.set("NamePlural", "potions of water");
        thing.set("UName", "watery potion");
        thing.set("Image", 243);
        thing.set("LevelMin", 1);
        thing.set("OnDip", new WaterDip());
        Lib.add(thing);
        thing = Lib.extend("potion of dirty water", "base potion");
        thing.set("NamePlural", "potions of dirty water");
        thing.set("UName", "watery potion");
        thing.set("Image", 243);
        thing.set("LevelMin", 6);
        Thing thing2 = Lib.create("sickness");
        Script script = Scripts.addEffect("Target", thing2, 50);
        thing.set("OnDrunk", script);
        Lib.add(thing);
        thing = Lib.extend("potion of holy water", "potion of water");
        thing.set("NamePlural", "potions of holy water");
        thing.set("IsBlessed", 1);
        thing.set("LevelMin", 9);
        thing.set("OnDrunk", Scripts.addEffect("Target", Lib.create("blessing")));
        Lib.add(thing);
        thing = Lib.extend("potion of unholy water", "potion of water");
        thing.set("NamePlural", "potions of unholy water");
        thing.set("LevelMin", 7);
        thing.set("IsCursed", 1);
        thing.set("OnDrunk", Scripts.addEffect("Target", Lib.create("curse")));
        Lib.add(thing);
        thing = Lib.extend("carrot juice", "base potion");
        thing.set("NamePlural", "carrot juices");
        thing.set("UName", "orange potion");
        thing.set("Image", 245);
        thing.set("LevelMin", 1);
        Lib.add(thing);
    }

    public static void initRandomPotions() {
        Thing thing = Lib.extend("healing salve", "base potion");
        thing.set("HealingPower", 7);
        thing.set("LevelMin", 1);
        thing.set("OnDrunk", new HealingScript());
        Potion.addPotion(thing);
        thing = Lib.extend("healing potion", "base potion");
        thing.set("HealingPower", 13);
        thing.set("LevelMin", 3);
        thing.set("OnDrunk", new HealingScript());
        Potion.addPotion(thing);
        thing = Lib.extend("potion of healing", "base potion");
        thing.set("HealingPower", 20);
        thing.set("LevelMin", 7);
        thing.set("OnDrunk", new HealingScript());
        Potion.addPotion(thing);
        thing = Lib.extend("strong healing potion", "base potion");
        thing.set("HealingPower", 40);
        thing.set("LevelMin", 13);
        thing.set("OnDrunk", new HealingScript());
        Potion.addPotion(thing);
        thing = Lib.extend("extra healing potion", "base potion");
        thing.set("HealingPower", 80);
        thing.set("LevelMin", 20);
        thing.set("OnDrunk", new HealingScript());
        Potion.addPotion(thing);
        thing = Lib.extend("ultra healing potion", "base potion");
        thing.set("HealingPower", 125);
        thing.set("LevelMin", 27);
        thing.set("OnDrunk", new HealingScript());
        Potion.addPotion(thing);
        thing = Lib.extend("potion of poison", "base potion");
        thing.set("LevelMin", 4);
        BaseObject baseObject = Lib.create("poison");
        Script script = Scripts.addEffect("Target", (Thing)baseObject);
        thing.set("OnDrunk", script);
        thing.set("DeathDecoration", "poison cloud");
        Potion.addPotion(thing);
        thing = Lib.extend("potion of misfortune", "base potion");
        thing.set("LevelMin", 6);
        baseObject = Lib.create("curse");
        script = Scripts.addEffect("Target", (Thing)baseObject);
        thing.set("OnDrunk", script);
        thing.set("DeathDecoration", "cloud of misfortune");
        Potion.addPotion(thing);
        thing = Lib.extend("potion of pestilence", "base potion");
        thing.set("LevelMin", 9);
        baseObject = Lib.create("pestilence");
        script = Scripts.addEffect("Target", (Thing)baseObject);
        thing.set("OnDrunk", script);
        thing.set("DeathDecoration", "cloud of pestilence");
        Potion.addPotion(thing);
        thing = Lib.extend("potion of confusion", "base potion");
        thing.set("LevelMin", 7);
        baseObject = Lib.create("confusion");
        script = Scripts.addEffect("Target", (Thing)baseObject);
        thing.set("OnDrunk", script);
        thing.set("DeathDecoration", "cloud of confusion");
        Potion.addPotion(thing);
        thing = Lib.extend("potion of speed", "base potion");
        thing.set("LevelMin", 2);
        baseObject = Effect.temporary(Modifier.bonus("MoveSpeed", 100), 2000);
        baseObject.set("EffectName", "accelerated");
        script = Scripts.addEffect("Target", (Thing)baseObject);
        thing.set("OnDrunk", script);
        Potion.addPotion(thing);
        thing = Lib.extend("potion of strength", "base potion");
        thing.set("LevelMin", 8);
        baseObject = Effect.temporary(Modifier.bonus("ST", RPG.d(6)), 2000);
        baseObject.set("EffectName", "strengthened");
        script = Scripts.addEffect("Target", (Thing)baseObject);
        thing.set("OnDrunk", script);
        Potion.addPotion(thing);
        thing = Lib.extend("potion of intelligence", "base potion");
        thing.set("LevelMin", 6);
        baseObject = Effect.temporary(Modifier.bonus("IN", RPG.d(6)), 2000);
        baseObject.set("EffectName", "brainy");
        script = Scripts.addEffect("Target", (Thing)baseObject);
        thing.set("OnDrunk", script);
        Potion.addPotion(thing);
        thing = Lib.extend("potion of charisma", "base potion");
        thing.set("LevelMin", 1);
        baseObject = Effect.temporary(Modifier.bonus("IN", RPG.d(8)), 2000);
        baseObject.set("EffectName", "charming");
        script = Scripts.addEffect("Target", (Thing)baseObject);
        thing.set("OnDrunk", script);
        Potion.addPotion(thing);
        thing = Lib.extend("potion of ferocity", "base potion");
        thing.set("LevelMin", 1);
        baseObject = Effect.temporary(Modifier.bonus("AttackSpeed", RPG.d(2, 30)), 2000);
        baseObject.set("EffectName", "ferocious");
        script = Scripts.addEffect("Target", (Thing)baseObject);
        thing.set("OnDrunk", script);
        Potion.addPotion(thing);
        thing = Lib.extend("potion of ethereality", "base potion");
        thing.set("LevelMin", 15);
        baseObject = Scripts.addEffect("Target", "ethereality");
        thing.set("OnDrunk", baseObject);
        Potion.addPotion(thing);
        thing = Lib.extend("potion of survival", "base potion");
        thing.set("LevelMin", 7);
        baseObject = Effect.temporary(Modifier.linear("IsImmortal", 0, 1), 1000);
        baseObject.set("EffectName", "staying alive");
        script = Scripts.addEffect("Target", (Thing)baseObject);
        thing.set("OnDrunk", script);
        Potion.addPotion(thing);
        thing = Lib.extend("potion of insanity", "base potion");
        thing.set("LevelMin", 11);
        baseObject = Effect.temporary(Modifier.linear("IsInsane", 0, 1), 30000);
        baseObject.set("EffectName", "slghtly mad");
        baseObject.set("ResistStat", "IN");
        baseObject.set("ResistDifficulty", 10);
        baseObject.set("ResistMessage", "You feel on the edge of sanity");
        baseObject.set("AddAttributeMessage", "You're feeling slightly mad");
        script = Scripts.addEffect("Target", (Thing)baseObject);
        thing.set("OnDrunk", script);
        Potion.addPotion(thing);
        thing = Lib.extend("potion of minor healing", "base potion");
        thing.set("HealingPower", 3);
        thing.set("LevelMin", 6);
        thing.set("OnDrunk", new HealingScript());
        Potion.addPotion(thing);
        thing = Lib.extend("potion of resilience", "base potion");
        thing.set("GainStat", "HPSMAX");
        thing.set("GainAmount", 1);
        thing.set("OnDrunk", new GainScript());
        thing.set("LevelMin", 1);
        Potion.addPotion(thing);
        thing = Lib.extend("potion of swift movement", "base potion");
        thing.set("GainStat", "MoveSpeed");
        thing.set("GainAmount", RPG.d(3));
        thing.set("OnDrunk", new GainScript());
        thing.set("LevelMin", 10);
        Potion.addPotion(thing);
        thing = Lib.extend("potion of aggressive tendencies", "base potion");
        thing.set("GainStat", "AttackSpeed");
        thing.set("GainAmount", 1);
        thing.set("OnDrunk", new GainScript());
        thing.set("LevelMin", 15);
        Potion.addPotion(thing);
        thing = Lib.extend("potion of fate", "base potion");
        thing.set("GainStat", "FatePoints");
        thing.set("GainAmount", 1);
        thing.set("OnDrunk", new GainScript());
        thing.set("LevelMin", 20);
        Potion.addPotion(thing);
        thing = Lib.extend("potion of cure poison", "base potion");
        thing.set("CurePoisonPower", 15);
        thing.set("LevelMin", 1);
        thing.set("OnDrunk", new HealingScript());
        Potion.addPotion(thing);
        thing = Lib.extend("potion of literacy", "base potion");
        thing.set("GainStat", "Literacy");
        thing.set("GainAmount", 1);
        thing.set("GainMax", 1);
        thing.set("OnDrunk", new GainScript());
        thing.set("LevelMin", 10);
        Potion.addPotion(thing);
        thing = Lib.extend("potion of repair", "base potion");
        thing.set("LevelMin", 3);
        thing.addHandler("OnDip", new Script(){
            private static final long serialVersionUID = 3257286915873911348L;

            public boolean handle(Thing thing, Event event) {
                Thing thing2 = event.getThing("Target");
                if (thing.getFlag("IsCursed")) {
                    Game.message("The potion seems to damage " + thing2.getYourName());
                    thing2.damage(thing2.getStat("HPSMAX") / 2, "special");
                } else if (Item.repair(thing2, false)) {
                    Game.message(thing2.getYourName() + " is surrounded by a shining orange light");
                } else {
                    Game.message(thing2.getYourName() + " glows orange for a second");
                }
                return false;
            }
        });
        Potion.addPotion(thing);
        thing = Lib.extend("potion of perfect repair", "base potion");
        thing.set("LevelMin", 23);
        thing.multiplyStat("Frequency", 0.3);
        thing.addHandler("OnDip", new Script(){
            private static final long serialVersionUID = 3906372640363917361L;

            public boolean handle(Thing thing, Event event) {
                Thing thing2 = event.getThing("Target");
                if (thing.getFlag("IsCursed")) {
                    Game.message(thing2.getYourName() + " is attacked by black magic!");
                    thing2.damage(thing2.getStat("HPSMAX"), "special");
                } else if (Item.repair(thing2, true)) {
                    Game.message(thing2.getYourName() + " is surrounded by a shining orange light");
                } else {
                    Game.message(thing2.getYourName() + " glows yellow for a second");
                }
                return false;
            }
        });
        Potion.addPotion(thing);
        thing = Lib.extend("potion of hunger", "base potion");
        thing.set("OnDrunk", new Script(){
            private static final long serialVersionUID = 3257290244507383856L;

            public boolean handle(Thing thing, Event event) {
                Thing thing2 = event.getThing("Target");
                int n = thing2.getStat("Hunger");
                int n2 = thing2.getStat("HungerThreshold");
                n = RPG.min(n, n2 * (thing.getFlag("IsCursed") ? 3 : 2));
                thing2.message("You feel hunger gnawing at your stomach");
                return false;
            }
        });
        thing.set("IsCursed", RPG.r(2));
        thing.set("LevelMin", 8);
        Lib.add(thing);
        thing = Lib.extend("potion of unlearning", "base potion");
        thing.set("OnDrunk", new Script(){
            private static final long serialVersionUID = 3833188016825840952L;

            public boolean handle(Thing thing, Event event) {
                Thing thing2 = event.getThing("Target");
                ArrayList arrayList = Skill.getList(thing2);
                String string = null;
                if (arrayList.size() > 0) {
                    string = Skill.trim((String)arrayList.get(RPG.r(arrayList.size())));
                }
                if (string != null && thing2.getBaseStat(string) > 0) {
                    thing2.incStat(string, -1);
                    thing2.message("You seem to remember less about " + string);
                    if (thing.getFlag("IsCursed")) {
                        thing2.incStat("SkillPoints", -1);
                    } else if ((thing.getFlag("IsBlessed") || RPG.d(2) == 1) && RPG.d(6) > 1) {
                        thing2.incStat("SkillPoints", 1);
                    }
                } else {
                    thing2.message("You feel pretty stupid");
                }
                return false;
            }
        });
        thing.set("LevelMin", 13);
        Potion.addPotion(thing);
        thing = Lib.extend("potion of minor talent", "base potion");
        thing.set("LevelMin", 1);
        thing.set("OnDrunk", Scripts.statGain("Target", "SK,ST,AG,TG,IN,WP,CH,CR", 12));
        Potion.addPotion(thing);
        thing = Lib.extend("potion of talent", "base potion");
        thing.set("LevelMin", 10);
        thing.set("OnDrunk", Scripts.statGain("Target", "SK,ST,AG,TG,IN,WP,CH,CR", 30));
        Potion.addPotion(thing);
        thing = Lib.extend("potion of greater talent", "base potion");
        thing.set("LevelMin", 20);
        thing.set("OnDrunk", Scripts.statGain("Target", "SK,ST,AG,TG,IN,WP,CH,CR", 50));
        Potion.addPotion(thing);
        thing = Lib.extend("potion of supreme talent", "base potion");
        thing.set("LevelMin", 32);
        thing.set("OnDrunk", Scripts.statGain("Target", "SK,ST,AG,TG,IN,WP,CH,CR", 90));
        Potion.addPotion(thing);
        thing = Lib.extend("potion of legendary talent", "base potion");
        thing.set("LevelMin", 42);
        thing.set("OnDrunk", Scripts.statGain("Target", "SK,ST,AG,TG,IN,WP,CH,CR", 170));
        Potion.addPotion(thing);
        thing = Lib.extend("potion of extra curing", "potion of cure poison");
        thing.set("CurePoisonPower", 60);
        Potion.addPotion(thing);
    }

    public static class GainScript
    extends Script {
        private static final long serialVersionUID = 3688503307446268472L;

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = (Thing)event.get("Target");
            int n = thing.getStat("GainMax");
            String string = thing.getString("GainStat");
            if (n > 0 && thing2.getBaseStat(string) >= n) {
                return false;
            }
            thing2.incStat(string, thing.getStat("GainAmount"));
            return false;
        }
    }

    public static class HealingScript
    extends Script {
        private static final long serialVersionUID = 3258130254312059186L;

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = (Thing)event.get("Target");
            if (thing.getFlag("HealingPower") && thing2.getFlag("HPS")) {
                int n = thing.getStat("HealingPower");
                Being.heal(thing2, n);
            }
            if (thing.getFlag("CurePoisonPower")) {
                Poison.cure(thing2, thing.getStat("CurePoisonPower"));
            }
            return false;
        }
    }

    private static class WaterDip
    extends Script {
        private static final long serialVersionUID = 3688784773950550576L;

        private WaterDip() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Target");
            Item.identify(thing);
            if (thing.getFlag("IsBlessed")) {
                Item.bless(thing2);
            } else if (thing.getFlag("IsCursed")) {
                Item.curse(thing2);
            }
            return true;
        }
    }

    private static class DipScript
    extends Script {
        private static final long serialVersionUID = 3258133544223061043L;

        private DipScript() {
        }

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("User");
            Thing thing3 = Game.selectItem("Select an item to apply the potion to:", thing2.getItems());
            if (thing3 == null) {
                return false;
            }
            thing.remove(1);
            if (thing3.getStat("Number") > 1) {
                thing3 = thing3.separate(RPG.d(4));
            }
            Potion.dip(thing2, thing3, thing);
            return true;
        }
    }
}

