/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import mikera.tyrant.Game;
import mikera.tyrant.ImageGadget;
import mikera.tyrant.InventoryPanel;
import mikera.tyrant.QuestApp;
import mikera.tyrant.Screen;
import mikera.tyrant.TPanel;
import mikera.tyrant.Thing;

public class InventoryScreen
extends Screen {
    private static final long serialVersionUID = 3546926861755103544L;
    String title = "List";
    static int page = 0;
    public Thing shopkeeper = null;
    protected TextField findField;
    protected InventoryPanel inventoryPanel;
    protected FindKeyOpener findKeyListener;
    protected Panel findPanel;
    protected boolean simplifiedFind;

    public void select() {
        this.getParent().remove(this);
    }

    protected void hideFindField() {
        this.findPanel.setVisible(false);
        this.findPanel.getParent().invalidate();
        this.findPanel.getParent().validate();
    }

    public InventoryScreen() {
        this(true, false);
    }

    public InventoryScreen(boolean bl) {
        this(bl, false);
    }

    public InventoryScreen(boolean bl, boolean bl2) {
        super(Game.getQuestapp());
        this.simplifiedFind = bl2;
        this.setLayout(new BorderLayout(0, 0));
        this.createFindPanel();
        this.inventoryPanel = new InventoryPanel(bl);
        this.add((Component)this.inventoryPanel, "Center");
        this.findKeyListener = new FindKeyOpener();
        this.addKeyListener(this.findKeyListener);
        this.inventoryPanel.addKeyListener(this.findKeyListener);
        this.setBackground(QuestApp.INFOSCREENCOLOUR);
        this.setForeground(QuestApp.INFOTEXTCOLOUR);
        this.setFont(QuestApp.mainfont);
        this.inventoryPanel.requestFocus();
    }

    public InventoryPanel getInventoryPanel() {
        return this.inventoryPanel;
    }

    private void createFindPanel() {
        ImageGadget imageGadget;
        this.findPanel = new TPanel(this.questapp);
        this.findPanel.setLayout(new GridBagLayout());
        this.add((Component)this.findPanel, "South");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        if (!this.simplifiedFind) {
            imageGadget = new ImageGadget("/images/cancel.png", "Filter: ");
            imageGadget.setBackgroundImage(this.getTexture());
            imageGadget.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    InventoryScreen.this.hideFindField();
                }
            });
            this.findPanel.add((Component)imageGadget, gridBagConstraints);
        }
        this.findField = new TextField();
        this.findField.setForeground(SystemColor.controlText);
        this.findField.setVisible(true);
        this.findField.addKeyListener(new FindFieldKeyListener());
        this.findField.addTextListener(new FindFieldTextListener());
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.findPanel.add((Component)this.findField, gridBagConstraints);
        if (!this.simplifiedFind) {
            imageGadget = ImageGadget.noImage("By name or by type %$[]=?+(/");
            imageGadget.setBackgroundImage(this.getTexture());
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.insets = new Insets(2, 10, 2, 2);
            this.findPanel.add((Component)imageGadget, gridBagConstraints);
        }
        this.findPanel.setVisible(false);
    }

    public void setUp(String string, Thing thing, Thing[] thingArray) {
        this.inventoryPanel.allThings = thingArray;
        this.inventoryPanel.title = string;
        this.inventoryPanel.shopkeeper = thing;
        this.inventoryPanel.filterThings();
    }

    public Thing getObject() {
        return (Thing)this.inventoryPanel.getObject();
    }

    public String getLine() {
        return this.inventoryPanel.getLine();
    }

    private final class FindKeyOpener
    extends KeyAdapter {
        private FindKeyOpener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 70 && (keyEvent.getModifiersEx() & 0x80) != 0) {
                this.showFindField();
            } else if (keyEvent.getKeyCode() == 47) {
                this.showFindField();
            } else if (keyEvent.getKeyCode() == 27) {
                InventoryScreen.this.inventoryPanel.filterThings(null);
                InventoryScreen.this.inventoryPanel.repaint();
            } else {
                String string = "" + keyEvent.getKeyChar();
                if (InventoryScreen.this.inventoryPanel.rougeLikeFilter.isRougeMatch(string)) {
                    InventoryScreen.this.inventoryPanel.filterThings(string);
                    InventoryScreen.this.inventoryPanel.repaint();
                }
            }
        }

        private void showFindField() {
            InventoryScreen.this.findPanel.setVisible(true);
            InventoryScreen.this.findField.requestFocus();
            InventoryScreen.this.findField.selectAll();
            InventoryScreen.this.inventoryPanel.filterThings(InventoryScreen.this.findField.getText());
            InventoryScreen.this.findPanel.getParent().invalidate();
            InventoryScreen.this.findPanel.getParent().validate();
        }
    }

    private final class FindFieldKeyListener
    extends KeyAdapter {
        private FindFieldKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                InventoryScreen.this.hideFindField();
                InventoryScreen.this.inventoryPanel.clearFilter();
            } else if (keyEvent.getKeyCode() == 10) {
                InventoryScreen.this.hideFindField();
            } else if (keyEvent.getKeyCode() == 40) {
                InventoryScreen.this.inventoryPanel.pageDown();
            } else if (keyEvent.getKeyCode() == 38) {
                InventoryScreen.this.inventoryPanel.pageUp();
            }
        }
    }

    private final class FindFieldTextListener
    implements TextListener {
        private FindFieldTextListener() {
        }

        public void textValueChanged(TextEvent textEvent) {
            InventoryScreen.this.inventoryPanel.filterThings(InventoryScreen.this.findField.getText());
        }
    }
}

