/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import mikera.tyrant.Armour;
import mikera.tyrant.BaseObject;
import mikera.tyrant.Being;
import mikera.tyrant.Coin;
import mikera.tyrant.Game;
import mikera.tyrant.IThingFilter;
import mikera.tyrant.IsFilter;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.NameFilter;
import mikera.tyrant.OrFilter;
import mikera.tyrant.QuestApp;
import mikera.tyrant.RogueLikeFilter;
import mikera.tyrant.Screen;
import mikera.tyrant.Spell;
import mikera.tyrant.Text;
import mikera.tyrant.Thing;
import mikera.tyrant.Weapon;

public class InventoryPanel
extends Screen
implements ItemSelectable {
    private static final long serialVersionUID = 3546926861755103544L;
    String title = "List";
    public Thing[] things;
    public Thing[] allThings;
    public static int page = 0;
    public static final int PAGESIZE = 16;
    private static final int LINEHEIGHT = 32;
    private static final int LINELENGTH = 75;
    public Thing shopkeeper = null;
    private String lastFilter;
    private IThingFilter filter;
    protected RogueLikeFilter rougeLikeFilter;
    private ItemListener itemListener;
    private Thing selected;
    private boolean isPollingMode;
    protected char charForThing;
    private ItemListener selfItemListener;

    public Object getObject() {
        this.allThings = this.things;
        boolean bl = false;
        while (!bl) {
            KeyEvent keyEvent = Game.getInput();
            Object object = this.handleKeyEvent(keyEvent);
            if (object == null) {
                return null;
            }
            if (!(object instanceof Thing)) continue;
            return object;
        }
        return null;
    }

    private Object handleKeyEvent(KeyEvent keyEvent) {
        if (keyEvent != null) {
            int n;
            int n2;
            if (keyEvent.getKeyCode() == 27) {
                return null;
            }
            if (keyEvent.getKeyCode() == 10) {
                return null;
            }
            int n3 = Character.toLowerCase(keyEvent.getKeyChar());
            if (keyEvent.getKeyCode() == 38) {
                n3 = 45;
            }
            if (keyEvent.getKeyCode() == 40) {
                n3 = 43;
            }
            if (n3 == 45) {
                this.pageUp();
            }
            if (n3 == 43 || n3 == 32 || n3 == 61) {
                this.pageDown();
            }
            if (n3 == 44) {
                n3 = 97;
            }
            if ((n2 = n3 - 97) >= 0 && n2 < 16 && (n = n2 + page * 16) >= 0 && n < this.things.length) {
                this.selected = this.things[n];
                this.fireSelectionEvent(this.selected);
                return this.selected;
            }
        }
        return this;
    }

    public String getLine() {
        String string = "";
        while (true) {
            KeyEvent keyEvent = Game.getInput();
            char c = keyEvent.getKeyChar();
            if (keyEvent.getKeyCode() == 10) break;
            if (keyEvent.getKeyCode() == 27) {
                string = "ESC";
                break;
            }
            if (keyEvent.getKeyCode() != 8) {
                if (!Character.isLetterOrDigit(c) && " -.:+'[]()=<>".indexOf(c) < 0) continue;
                string = string + c;
                this.title = this.title + c;
                this.repaint();
                continue;
            }
            if (string.length() <= 0) continue;
            string = string.substring(0, string.length() - 1);
            this.repaint();
        }
        return string;
    }

    public void pageUp() {
        if (page > 0) {
            --page;
            this.repaint();
        }
    }

    public void pageDown() {
        if ((page + 1) * 16 < this.things.length) {
            ++page;
            this.repaint();
        }
    }

    public InventoryPanel(boolean bl) {
        this();
        this.isPollingMode = bl;
        if (this.isPollingMode) {
            this.selfHookItemListener();
        } else {
            this.selfHookKeyEvents();
        }
    }

    private void selfHookItemListener() {
        this.selfItemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                InventoryPanel.this.removeItemListener(InventoryPanel.this.selfItemListener);
                Game.simulateKey(InventoryPanel.this.charForThing);
                InventoryPanel.this.addItemListener(InventoryPanel.this.selfItemListener);
            }
        };
        this.addItemListener(this.selfItemListener);
    }

    public InventoryPanel() {
        super(Game.getQuestapp());
        this.setBackground(QuestApp.INFOSCREENCOLOUR);
        this.setForeground(QuestApp.INFOTEXTCOLOUR);
        this.setFont(QuestApp.mainfont);
        this.rougeLikeFilter = new RogueLikeFilter();
        this.filter = new OrFilter(this.rougeLikeFilter, new NameFilter(), new IsFilter());
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getY();
                for (int i = 0; i < Math.min(InventoryPanel.this.things.length - page * 16, 16); ++i) {
                    int n2 = InventoryPanel.this.getYPosition(i);
                    if (n < n2 || n >= n2 + 32) continue;
                    int n3 = i + page * 16;
                    InventoryPanel.this.charForThing = InventoryPanel.this.getDisplayChar(i);
                    InventoryPanel.this.fireSelectionEvent(InventoryPanel.this.things[n3]);
                }
            }
        });
    }

    public void selfHookKeyEvents() {
        this.removeKeyListener(Game.getQuestapp().keyadapter);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                InventoryPanel.this.handleKeyEvent(keyEvent);
            }
        });
    }

    private String getItemText(Thing thing) {
        Thing thing2 = Game.hero();
        if (thing.getFlag("IsSpell")) {
            return Spell.selectionString(thing2, thing, 75);
        }
        String string = thing.getName(null);
        if (thing.getStat("HPS") < thing.getStat("HPSMAX")) {
            string = "damaged " + string;
        }
        if (thing.getFlag("IsWeapon") && Item.isIdentified(thing)) {
            string = string + "  " + Weapon.statString(thing);
        }
        if (thing.getFlag("IsArmour") && Item.isIdentified(thing)) {
            string = string + "  " + Armour.statString(thing);
        }
        String string2 = Lib.wieldDescription(thing.y);
        string2 = thing.place == thing2 && string2 != null ? "(" + string2 + ")" : "";
        if (this.shopkeeper == null) {
            string = Text.centrePad(string, string2, 75);
            string = string + Text.centrePad("  ", thing.getWeight() / 100 + "s", 7);
        } else {
            string = Text.centrePad(string, string2, 60);
            if (!thing.getFlag("IsMoney")) {
                string = string + Text.centrePad("  ", Coin.valueString(Item.shopValue(thing, Game.hero(), this.shopkeeper)), 20);
            }
        }
        return string;
    }

    public void paint(Graphics graphics) {
        Object object;
        super.paint(graphics);
        graphics.setColor(QuestApp.INFOTEXTCOLOUR);
        if (this.title != null) {
            graphics.drawString(this.title, 20, 32);
        }
        if (this.things == null || this.allThings == null) {
            return;
        }
        if (page * 16 > this.things.length) {
            page = 0;
        }
        for (int i = 0; i < Math.min(this.things.length - page * 16, 16); ++i) {
            object = this.things[i + page * 16];
            String string = "[" + this.getDisplayChar(i) + "] " + this.getItemText((Thing)object);
            int n = this.getYPosition(i);
            Color color = QuestApp.INFOTEXTCOLOUR;
            if (((BaseObject)object).getFlag("IsStatusKnown")) {
                color = ((BaseObject)object).getFlag("IsBlessed") ? Color.GREEN.darker() : (((BaseObject)object).getFlag("IsCursed") ? Color.RED : color.darker());
            }
            graphics.setColor(color);
            graphics.drawString(string, 70, n + 18);
            if (!((BaseObject)object).containsKey("Image")) continue;
            int n2 = ((Thing)object).getStat("Image");
            int n3 = n2 % 20 * 32;
            int n4 = n2 / 20 * 32;
            int n5 = 30;
            int n6 = n;
            graphics.drawImage((Image)QuestApp.images.get(((Thing)object).get("ImageSource")), n5, n6, n5 + 32, n6 + 32, n3, n4, n3 + 32, n4 + 32, null);
        }
        graphics.setColor(QuestApp.INFOTEXTCOLOUR);
        String string = "ESC=Cancel    /=Filter";
        if (page > 0) {
            string = string + " Up=Previous ";
        }
        if ((page + 1) * 16 < this.things.length) {
            string = string + " Down=Next ";
        }
        object = "Weight: " + Game.hero().getInventoryWeight() / 100 + " / " + Being.maxCarryingWeight(Game.hero()) / 100 + "s";
        if (this.allThings.length != this.things.length) {
            object = (String)object + "    *Filtering* " + this.lastFilter;
        }
        graphics.drawString(Text.centrePad(string, (String)object, 80), 20, this.getSize().height - 10);
    }

    public int getYPosition(int n) {
        return 32 * (n + 1) + 8;
    }

    public char getDisplayChar(int n) {
        return (char)(97 + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterThings(String string) {
        this.lastFilter = string;
        try {
            if (string == null) {
                this.things = this.allThings;
                this.lastFilter = "";
                return;
            }
            ArrayList<Thing> arrayList = new ArrayList<Thing>();
            for (int i = 0; i < this.allThings.length; ++i) {
                Thing thing = this.allThings[i];
                if (!this.filter.accept(thing, string)) continue;
                arrayList.add(thing);
            }
            this.things = arrayList.toArray(new Thing[arrayList.size()]);
        }
        finally {
            this.repaint();
        }
    }

    public void filterThings() {
        this.filterThings(this.lastFilter);
    }

    public void clearFilter() {
        this.filterThings(null);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    private void fireSelectionEvent(Thing thing) {
        this.selected = thing;
        if (this.itemListener == null) {
            return;
        }
        this.itemListener.itemStateChanged(new ItemEvent(this, 701, thing, 1));
    }

    public void removeItemListener(ItemListener itemListener) {
        if (this.itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public Object[] getSelectedObjects() {
        return new Object[]{this.selected};
    }
}

