/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Event;
import mikera.tyrant.Game;
import mikera.tyrant.Item;
import mikera.tyrant.Lib;
import mikera.tyrant.Map;
import mikera.tyrant.RPG;
import mikera.tyrant.Score;
import mikera.tyrant.Script;
import mikera.tyrant.Thing;
import mikera.tyrant.Trap;

public class Door {
    public static boolean useRiddleDoor(Thing thing, Thing thing2) {
        if (!thing2.getFlag("IsOpen") && thing.isHero()) {
            if (thing.getFlag(thing2.getString("RiddleStatName"))) {
                Door.setOpen(thing2, true);
            } else if (thing2.getFlag("IsInvisible")) {
                Game.message("Something is preventing you from moving forward");
            } else {
                Game.message("This door appears to be magically locked.");
            }
        }
        return false;
    }

    public static boolean useQuestDoor(Thing thing, Thing thing2) {
        if (!thing2.getFlag("IsOpen") && thing.isHero()) {
            if (thing.getFlag("HasQuest")) {
                Door.setOpen(thing2, true);
            } else {
                Game.message("It appears to be impossible to open this door.");
            }
        }
        return false;
    }

    public static Thing create() {
        return Door.create(Game.hero().getLevel());
    }

    public static Thing create(int n) {
        return Lib.createType("IsDoor", n);
    }

    public static Thing createDoor(int n) {
        return Lib.createType("IsDoor", n);
    }

    public static Thing createToughDoor(int n) {
        Thing thing = Lib.createType("IsDoor", n + 6);
        thing.set("IsLocked", 1);
        return thing;
    }

    protected static String chooseKey(int n) {
        Thing thing = Lib.createType("IsKey", n);
        return thing.name();
    }

    protected static void setOpen(Thing thing, boolean bl) {
        Event event = new Event(bl ? "Open" : "Close");
        if (thing.handle(event)) {
            return;
        }
        Score.scoreExplore(thing);
        thing.set("IsBlocking", bl ? 0 : 1);
        thing.set("IsOpen", bl ? 1 : 0);
        thing.set("IsViewBlocking", bl ? 0 : Lib.getDefaultStat(thing, "IsViewBlocking"));
        int n = Lib.getDefaultStat(thing, "Image") + (bl ? Lib.getDefaultStat(thing, "ImageOpen") : 0);
        thing.set("Image", n);
    }

    public static boolean canLock(Thing thing, Thing thing2) {
        if (!thing.getFlag("IsKey")) {
            return false;
        }
        if (!thing2.getFlag("IsDoor")) {
            return false;
        }
        if (thing2.getFlag("IsOpen")) {
            return false;
        }
        if (thing2.getFlag("IsLocked")) {
            return false;
        }
        return Door.keyFits(thing, thing2);
    }

    public static boolean keyFits(Thing thing, Thing thing2) {
        String string = thing2.getString("KeyName");
        return thing.name().equals(string);
    }

    public static boolean unlock(Thing thing, Thing thing2) {
        if (!thing2.getFlag("IsLocked")) {
            return false;
        }
        if (!Door.keyFits(thing, thing2)) {
            return false;
        }
        thing2.set("IsLocked", 0);
        return true;
    }

    public static void lockedOptions(Thing thing, Thing thing2) {
        Game.message(thing2.getTheName() + " is locked");
        String string = thing2.getString("KeyName");
        if (string != null && thing.hasItem(string)) {
            Thing thing3 = thing.getItem(string);
            Game.message(thing3.getYourName() + " fits the lock.");
            Game.message("You unlock " + thing2.getTheName());
            thing2.set("IsLocked", 0);
            return;
        }
        int n = thing2.getStat("LockDifficulty");
        if (n == 0) {
            n = thing2.getStat("Level") * 3;
        }
        int n2 = thing.getStat("CR") * thing.getStat("Lockpicking");
        Thing thing4 = thing.getItem("lock pick");
        if (thing4 != null && thing.getStat("Lockpicking") > 0) {
            Game.message("Attempt to pick lock? (y/n)");
            char c = Game.getOption("yn");
            if (c == 'y') {
                if (n >= 0 && RPG.test(n2, n)) {
                    Game.message("You succeed in picking the lock!");
                    thing2.set("IsLocked", 0);
                } else {
                    thing4 = thing4.remove(1);
                    Game.message(thing4.getYourName() + " breaks.");
                }
            } else {
                Game.message("");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean useDoor(Thing thing, Thing thing2) {
        Map map = thing2.getMap();
        Item.touch(thing, thing2);
        if (!thing2.getFlag("IsOpen")) {
            if (thing2.getFlag("IsLocked") || !thing.isHero() && thing.getStat("CR") < 7) {
                if (!thing.isHero()) return false;
                Door.lockedOptions(thing, thing2);
                return true;
            }
            if (thing.isHero()) {
                Game.message("You open " + thing2.getTheName());
            }
            Door.setOpen(thing2, true);
            thing.incStat("APS", -200);
            return true;
        }
        if (map.isBlocked(thing2.x, thing2.y)) {
            if (!thing.isHero()) return false;
            Game.message("You can't close " + thing2.getTheName());
            return false;
        } else {
            if (thing.isHero()) {
                Game.message("You close " + thing2.getTheName());
            }
            Door.setOpen(thing2, false);
            thing.incStat("APS", -200);
        }
        return false;
    }

    public static void init() {
        Door.initDoors();
    }

    private static void initDoors() {
        Thing thing = Lib.extend("base door", "base scenery");
        thing.set("UName", "door");
        thing.set("IsScenery", 0);
        thing.set("IsDoor", 1);
        thing.set("IsOpenable", 1);
        thing.set("Image", 144);
        thing.set("ImageOpen", 1);
        thing.set("Z", 21);
        thing.set("Frequency", 50);
        thing.set("IsOpen", 0);
        thing.set("IsViewBlocking", 1);
        thing.set("LevelMin", 1);
        thing.set("IsBlocking", 1);
        thing.set("IsJumpable", 0);
        thing.set("IsTownDoor", 0);
        thing.set("OpenResistance", 5);
        thing.set("HPS", 30);
        thing.set("OnBump", new DoorBump());
        thing.set("ScoreExplore", 1);
        thing.set("ASCII", "+");
        thing.set("MapColour", 7356448);
        thing.set("OnCreate", new DoorCreation());
        thing.set("DefaultThings", "10% [IsTrap]");
        thing.addHandler("OnDamage", new DoorDamage());
        Lib.add(thing);
        thing = Lib.extend("door", "base door");
        thing.set("LevelMin", 1);
        thing.set("IsTownDoor", 1);
        Lib.add(thing);
        thing = Lib.extend("locked door", "base door");
        thing.set("LevelMin", 6);
        thing.set("IsTownDoor", 1);
        thing.set("IsLocked", 1);
        thing.multiplyStat("Frequency", 0.1);
        Lib.add(thing);
        thing = Lib.extend("weak locked door", "base door");
        thing.set("LevelMin", 2);
        thing.set("IsLocked", 1);
        thing.set("HPS", 2);
        thing.multiplyStat("Frequency", 0.1);
        Lib.add(thing);
        thing = Lib.extend("rotten door", "base door");
        thing.set("LevelMin", 3);
        thing.multiplyStat("Frequency", 0.3);
        thing.addHandler("OnOpen", new Script(){
            private static final long serialVersionUID = 4120849971320142133L;

            public boolean handle(Thing thing, Event event) {
                if (thing.isVisible(Game.hero())) {
                    Game.message(thing.getTheName() + " crumbles into dust");
                }
                thing.die();
                return true;
            }
        });
        Lib.add(thing);
        thing = Lib.extend("strong door", "door");
        thing.set("UName", "strong door");
        thing.set("HPS", 100);
        thing.set("OpenResistance", 20);
        thing.set("LevelMin", 5);
        Lib.add(thing);
        thing = Lib.extend("stone door", "door");
        thing.set("UName", "stone door");
        thing.set("Image", 146);
        thing.set("HPS", 300);
        thing.set("OpenResistance", 30);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("shop door", "door");
        thing.set("UName", "shop door");
        thing.set("Image", 148);
        thing.set("Frequency", 0);
        thing.set("IsWarning", 1);
        thing.set("HPS", 60);
        Lib.add(thing);
        thing = Lib.extend("ornate door", "door");
        thing.set("UName", "ornate door");
        thing.set("Image", 148);
        thing.set("HPS", 60);
        thing.set("LevelMin", 7);
        thing.set("IsTownDoor", 1);
        Lib.add(thing);
        thing = Lib.extend("enchanted door", "door");
        thing.set("Image", 148);
        thing.set("HPS", 1300);
        thing.set("LevelMin", 9);
        thing.set("OpenResistance", 0);
        thing.set("IsLocked", 1);
        thing.set("LockDifficulty", -1);
        thing.multiplyStat("Frequency", 0.1);
        thing.addHandler("OnAction", new Script(){
            private static final long serialVersionUID = 3761692294637435190L;

            public boolean handle(Thing thing, Event event) {
                int n = event.getStat("Time");
                Map map = thing.getMap();
                if (map == null) {
                    return false;
                }
                if (RPG.po(n, 2000) > 0 && !map.isBlocked(thing.x, thing.y)) {
                    Door.setOpen(thing, !thing.getFlag("IsOpen"));
                }
                return false;
            }
        });
        Lib.add(thing);
        thing = Lib.extend("heavy oak door", "strong door");
        thing.set("HPS", 200);
        thing.set("OpenResistance", 20);
        thing.set("ARM", 10);
        thing.set("IsTownDoor", 1);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("goblin door", "door");
        thing.set("UName", "green door");
        thing.set("Image", 152);
        thing.set("HPS", 60);
        thing.set("DefaultThings", "[IsTrap]");
        thing.set("LevelMin", 13);
        Lib.add(thing);
        thing = Lib.extend("black door", "door");
        thing.set("UName", "black door");
        thing.set("Image", 154);
        thing.set("HPS", 160);
        thing.set("IsTownDoor", 1);
        thing.set("OpenResistance", 20);
        thing.set("LevelMin", 10);
        Lib.add(thing);
        thing = Lib.extend("trapped black door", "black door");
        thing.set("LevelMin", 12);
        thing.set("IsLocked", 1);
        thing.set("IsTownDoor", 1);
        thing.multiplyStat("Frequency", 0.4);
        thing.set("DefaultThings", "[IsTrap]");
        Lib.add(thing);
        thing = Lib.extend("trapped door", "door");
        thing.set("UName", "black door");
        thing.set("Image", 154);
        thing.set("HPS", 16);
        thing.set("IsLocked", 1);
        thing.multiplyStat("Frequency", 0.4);
        thing.set("DefaultThings", "[IsTrap]");
        thing.set("LevelMin", 5);
        Lib.add(thing);
        thing = Lib.extend("graveyard door", "black door");
        thing.set("Image", 154);
        thing.set("IsDestructible", 0);
        thing.set("Frequency", 0);
        thing.set("LevelMin", 13);
        thing.set("ScoreExplore", 50);
        thing.set("KeyName", "skull key");
        thing.set("OnAction", new Script(){
            private static final long serialVersionUID = 3258413915376333623L;

            public boolean handle(Thing thing, Event event) {
                Map map = thing.getMap();
                if (map.getFlag("IsHostile")) {
                    Door.setOpen(thing, false);
                    thing.set("IsLocked", true);
                    thing.set("OnAction", null);
                }
                return false;
            }
        });
        Lib.add(thing);
        thing = Lib.extend("unbreakable door", "door");
        thing.set("UName", "door");
        thing.set("IsDestructible", 0);
        thing.set("Frequency", 0);
        thing.set("IsLocked", 1);
        thing.set("OpenResistance", 0);
        thing.set("LockDifficulty", -1);
        thing.set("Image", 154);
        Lib.add(thing);
        thing = Lib.extend("quest door", "unbreakable door");
        thing.set("Frequency", 0);
        thing.set("OnBump", new QuestDoorBump());
        Lib.add(thing);
        thing = Lib.extend("riddle door", "unbreakable door");
        thing.set("Frequency", 0);
        thing.set("OnBump", new RiddleDoorBump());
        Lib.add(thing);
        thing = Lib.extend("invisible riddle door", "riddle door");
        thing.set("IsInvisible", 1);
        Lib.add(thing);
        thing = Lib.extend("portcullis", "door");
        thing.set("UName", "portcullis");
        thing.set("IsPortcullis", 1);
        thing.set("Image", 140);
        thing.set("IsViewBlocking", 0);
        thing.set("LevelMin", 3);
        thing.set("IsTownDoor", 1);
        thing.set("OpenResistance", 0);
        thing.set("HPS", 560);
        thing.set("ScoreExplore", 3);
        Lib.add(thing);
        thing = Lib.extend("golden portcullis", "portcullis");
        thing.set("Image", 142);
        thing.set("IsViewBlocking", 0);
        thing.set("HPS", 1560);
        thing.set("LevelMin", 18);
        Lib.add(thing);
        thing = Lib.extend("invincible portcullis", "golden portcullis");
        thing.set("IsDestructible", 0);
        thing.set("Frequency", 0);
        thing.set("LevelMin", 18);
        thing.set("IsLocked", 1);
        thing.set("LockDifficulty", -1);
        Lib.add(thing);
        thing = Lib.extend("stable door", "door");
        thing.set("Image", 150);
        thing.set("Frequency", 0);
        thing.set("IsViewBlocking", 0);
        thing.set("IsJumpable", 1);
        thing.set("HPS", 28);
        Lib.add(thing);
    }

    public static class DoorDamage
    extends Script {
        private static final long serialVersionUID = 3904677184760132917L;

        public boolean handle(Thing thing, Event event) {
            int n;
            int n2;
            Thing[] thingArray = thing.getFlaggedContents("IsTrap");
            Map map = thing.getMap();
            Thing thing2 = event.getThing("Actor");
            for (n2 = 0; n2 < thingArray.length; ++n2) {
                Game.warn(thingArray[n2].name() + " triggered on door");
                if (thing2 == null) {
                    thing2 = Game.hero();
                }
                int n3 = thing.x + RPG.sign(thing2.x - thing.x);
                n = thing.y + RPG.sign(thing2.y - thing.y);
                if (n3 != thing.x && !map.isTileBlocked(n3, thing.y)) {
                    n = thing.y;
                } else {
                    n3 = thing.x;
                }
                map.addThing(thingArray[n2], n3, n);
                Trap.trigger(thingArray[n2]);
            }
            n2 = event.getStat("Damage");
            String string = event.getString("DamageType");
            if (string.equals("impact") && !thing.getFlag("IsOpen") && (n = thing.getStat("OpenResistance")) > 0 && RPG.test(n2, n)) {
                thing.visibleMessage(thing.getTheName() + " is smashed open");
                Door.setOpen(thing, true);
            }
            return false;
        }
    }

    public static class QuestDoorBump
    extends Script {
        private static final long serialVersionUID = 8212975466499234213L;

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Target");
            event.set("ActionTaken", Door.useQuestDoor(thing2, thing));
            return false;
        }
    }

    public static class RiddleDoorBump
    extends Script {
        private static final long serialVersionUID = -3945891430842518588L;

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Target");
            event.set("ActionTaken", Door.useRiddleDoor(thing2, thing));
            return false;
        }
    }

    public static class DoorBump
    extends Script {
        private static final long serialVersionUID = 3904958655442006583L;

        public boolean handle(Thing thing, Event event) {
            Thing thing2 = event.getThing("Target");
            event.set("ActionTaken", Door.useDoor(thing2, thing));
            return false;
        }
    }

    public static class DoorCreation
    extends Script {
        private static final long serialVersionUID = 3904958655442006583L;

        public boolean handle(Thing thing, Event event) {
            String string = thing.getString("KeyName");
            if (string == null) {
                thing.set("KeyName", Door.chooseKey(thing.getLevel()));
            }
            return false;
        }
    }
}

