/*
 * Decompiled with CFR 0.152.
 */
package mikera.tyrant;

import mikera.tyrant.Lib;
import mikera.tyrant.Modifier;
import mikera.tyrant.RPG;
import mikera.tyrant.Thing;

public class Amulet {
    private static String[] types = new String[]{"gold", "silver", "ivory", "ruby", "firestone", "amber", "aquamarine", "amethyst", "emerald"};
    private static int[] images = new int[]{400, 401, 401, 402, 402, 403, 404, 405, 406};

    private static void addNecklace(Thing thing) {
        String string;
        int n = RPG.r(types.length);
        thing.set("ImageSource", "Items");
        thing.set("Image", images[n]);
        thing.set("UName", types[n] + " necklace");
        String string2 = thing.getString("Name");
        if (string2.indexOf("necklace") == 0) {
            string = "necklaces" + string2.substring(8);
            thing.set("NamePlural", string);
        }
        if (string2.indexOf("amulet") == 0) {
            string = "amulets" + string2.substring(6);
            thing.set("NamePlural", string);
        }
        if (string2.indexOf("talisman") == 0) {
            string = "talismans" + string2.substring(6);
            thing.set("NamePlural", string);
        }
        Lib.add(thing);
    }

    public static void init() {
        Thing thing = Lib.extend("base necklace", "base item");
        thing.set("ItemWeight", 500);
        thing.set("ValueBase", 700);
        thing.set("LevelMin", 1);
        thing.set("IsNecklace", 1);
        thing.set("HPS", 8);
        thing.set("Frequency", 30);
        thing.set("WieldType", 6);
        Lib.add(thing);
        Amulet.initNecklaces();
        Amulet.initAmulets();
    }

    public static void initNecklaces() {
        for (int i = 0; i < types.length; ++i) {
            Thing thing = Lib.extend(types[i] + " necklace", "base necklace");
            Amulet.addNecklace(thing);
        }
    }

    public static void initAmulets() {
        Thing thing = Lib.extend("base amulet", "base necklace");
        thing.set("IsMacicItem", 1);
        thing.set("ValueBase", 1000);
        Lib.add(thing);
        thing = Lib.extend("amulet of wrath", "base amulet");
        thing.set("LevelMin", 18);
        thing.add("WieldedModifiers", Modifier.bonus("Attack", RPG.d(3)));
        thing.add("WieldedModifiers", Modifier.bonus("AttackSpeed", RPG.d(2, 20)));
        Amulet.addNecklace(thing);
        thing = Lib.extend("amulet of regeneration", "base amulet");
        thing.set("LevelMin", 3);
        thing.add("WieldedModifiers", Modifier.bonus("RegenerationRate", 30));
        Amulet.addNecklace(thing);
        thing = Lib.extend("amulet of protection", "base amulet");
        thing.set("LevelMin", 9);
        thing.add("WieldedModifiers", Modifier.bonus("ARM", RPG.d(6)));
        Amulet.addNecklace(thing);
        thing = Lib.extend("amulet of confusion", "base amulet");
        thing.set("LevelMin", 7);
        thing.add("WieldedModifiers", Modifier.bonus("IsConfused", 1));
        thing.set("IsCursed", 1);
        Amulet.addNecklace(thing);
        thing = Lib.extend("amulet of spellcasting", "base amulet");
        thing.set("LevelMin", 12);
        thing.add("WieldedModifiers", Modifier.bonus("Spellcasting", RPG.d(3)));
        thing.add("WieldedModifiers", Modifier.bonus("IN", RPG.d(2, 3)));
        Amulet.addNecklace(thing);
        thing = Lib.extend("amulet of courage", "base amulet");
        thing.set("LevelMin", 2);
        thing.add("WieldedModifiers", Modifier.bonus("Bravery", RPG.d(3)));
        Amulet.addNecklace(thing);
        thing = Lib.extend("amulet of motion", "base amulet");
        thing.set("LevelMin", 16);
        thing.add("WieldedModifiers", Modifier.linear("Encumberance", 70, 0));
        Amulet.addNecklace(thing);
        thing = Lib.extend("amulet of fire resistance", "base amulet");
        thing.set("LevelMin", 5);
        thing.add("WieldedModifiers", Modifier.bonus("RES:fire", 10));
        Amulet.addNecklace(thing);
        thing = Lib.extend("amulet of ice resistance", "base amulet");
        thing.set("LevelMin", 10);
        thing.add("WieldedModifiers", Modifier.bonus("RES:ice", 10));
        Amulet.addNecklace(thing);
        thing = Lib.extend("amulet of acid resistance", "base amulet");
        thing.set("LevelMin", 15);
        thing.add("WieldedModifiers", Modifier.bonus("RES:acid", 10));
        Amulet.addNecklace(thing);
        thing = Lib.extend("amulet of shock resistance", "base amulet");
        thing.set("LevelMin", 20);
        thing.add("WieldedModifiers", Modifier.bonus("RES:shock", 10));
        Amulet.addNecklace(thing);
        thing = Lib.extend("amulet of chill resistance", "base amulet");
        thing.set("LevelMin", 25);
        thing.add("WieldedModifiers", Modifier.bonus("RES:chill", 10));
        Amulet.addNecklace(thing);
        thing = Lib.extend("amulet of poison resistance", "base amulet");
        thing.set("LevelMin", 30);
        thing.add("WieldedModifiers", Modifier.bonus("RES:chill", 10));
        Amulet.addNecklace(thing);
        thing = Lib.extend("amulet of disintegration resistance", "base amulet");
        thing.set("LevelMin", 35);
        thing.add("WieldedModifiers", Modifier.bonus("RES:disintegrate", 10));
        Amulet.addNecklace(thing);
    }
}

